/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.xsd;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;

public interface XsdSchema {
    public static final String CURRENT_VERSION = "4.03";
    public static final List<String> SUPPORTED_VERSIONS = Collections.unmodifiableList(Arrays.asList("4.02", "4.03"));
    public static final Map<String, XMLValidationSchema> VERSION_2_XSD = SUPPORTED_VERSIONS.stream().collect(Collectors.toMap(version -> version, version -> XsdSchema.loadSchemaResource("/xsd/" + version + "/PaymentData.xsd")));

    public static XMLValidationSchema loadSchemaResource(String resourcePath) {
        URL classpathResource = XsdSchema.class.getResource(resourcePath);
        if (classpathResource == null) {
            throw new IllegalArgumentException("XSD schema not found: " + resourcePath);
        }
        try {
            return XMLValidationSchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").createSchema(classpathResource);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(String.format("Failed to create schema from resource '%s'", resourcePath), e);
        }
    }
}

